:: windows batch script to install a license file to a
:: V 1.x.x Pulse Streamer via ssh connection
:: Christof Skupin <christof@swabianinstruments.com>
:: copyright Swabian Instruments 2021
@echo off

if [%1] == [] (
    echo IP/hostname parameter is empty.
    echo.
    echo Please use
    echo "install_lic.bat pulsestreamer"
    echo in case the hostname is pulsestreamer or
    echo "install_lic.bat IPADRESS"
    echo and replace IPADRESS by the ip address, e.g. 192.168.0.1
    pause
    exit /B 1
)

if [%2] == [] (
    echo Password parameter is empty.
    echo.
    echo To update the Pulse Streamer please use
    echo "update_system.bat pulsestreamer xyz"
    echo in case the hostname is pulsestreamer or
    echo "update_system.bat IPADRESS xyz"
    echo and replace IPADRESS by the ip address, e.g. 192.168.0.1
    echo and xyz with the login password of your Pulse Streamer
    pause
    exit /B 1
)

if not exist plink.exe (
    echo plink.exe is missing.
    exit /B 2
)

if not exist pscp.exe (
    echo pscp.exe is missing.
    exit /B 2
)

if not exist wget.exe (
    echo wget.exe is missing.
    exit /B 2
)

set HOST=%1
set PASSWORD=%2

echo Connect to Pulse Streamer %1
wget --timeout 5 --tries=10 -q -O - --post-data={\"jsonrpc\":\"2.0\",\"id\":\"0\",\"method\":\"getFirmwareVersion\"} --header=Content-Type:application/json http://%HOST%:8050/json-rpc
if %ERRORLEVEL% GEQ 1 (
    echo Connection Error: Could not establish a connection for RPC to Pulse Streamer %1. Aborting.
    pause
    exit /B 3
)
echo.

REM copy license
echo Uploading license file

pscp -scp -pw %PASSWORD% lic.dat root@%HOST%:/
echo.

REM flash license
echo Flashing license...
echo Please wait - (1 minute)
wget -q -O - --post-data={\"jsonrpc\":\"2.0\",\"id\":\"0\",\"method\":\"flash_lic\"} --header=Content-Type:application/json http://%HOST%:8050/json-rpc > tmp.txt
set /p lic_resp= < tmp.txt
del tmp.txt
REM echo %lic_resp%
for /F "tokens=3 delims=," %%a in ("%lic_resp%") do (
   REM echo %%a
   set answer_1=%%a
)
for /F "tokens=2 delims=:}" %%b in ("%answer_1%") do (
    REM echo %%b
    set answer_2=%%b
)
REM echo %answer_2%
IF %answer_2%=="corrupt license file" (
    echo corrupt license file - make sure you have the right lic.dat in the update folder or contact support@swabianinstruments.com
    EXIT /B 4
)
IF %answer_2%=="no license found" (
    echo no license found - make sure you have the right lic.dat in the update folder or contact support@swabianinstruments.com
    EXIT /B 5
)
IF %answer_2%=="Flashing not succesful - please reboot and try again. For support contact support@swabianinstrumnets.com" (
    echo Flashing not successful - please reboot and try again. For support contact support@swabianinstrumnets.com
    EXIT /B 6
)
echo.

REM Reboot Pulse Streamer
plink root@%HOST% -pw %PASSWORD% "/sbin/reboot"

echo Rebooting Pulse Streamer, please wait ... (30s)
timeout /t 30  /nobreak > NUL

wget --timeout 5 --tries=10 -q -O - --post-data={\"jsonrpc\":\"2.0\",\"id\":\"0\",\"method\":\"getFirmwareVersion\"} --header=Content-Type:application/json http://%HOST%:8050/json-rpc
echo.
wget --timeout 5 --tries=10 -q -O - --post-data={\"jsonrpc\":\"2.0\",\"id\":\"0\",\"method\":\"getFirmwareVersion\"} --header=Content-Type:application/json http://%HOST%:8050/json-rpc > tmp.txt
set /p lic_resp= < tmp.txt
del tmp.txt
REM echo %lic_resp%
for /F "tokens=3 delims=," %%a in ("%lic_resp%") do (
   REM echo %%a
   set answer_1=%%a
)
for /F "tokens=2 delims=:}" %%b in ("%answer_1%") do (
    REM echo %%b
    set answer_2=%%b
)
REM echo %answer_2%
echo %answer_2% > tmp.txt
FOR %%? IN (tmp.txt) DO ( SET /A strlength=%%~z? - 2 )
del tmp.txt

if %strlength% gtr 11 (
    echo.
    echo No valid license installed! For support contact support@swabianinstruments.com
    EXIT /B 7
)

echo.
echo License has been installed succesfully for version: %answer_2:"=%

pause



